<?php
/**
	 * Template Style Twenty Five for Team
	 *
	 * @package AbsoluteAddons
	 */

defined( 'ABSPATH' ) || exit;

$unique_id = wp_unique_id();

?>
<div class="absp-team-item">
	<div class="holder">
		<div class="pic">
			<div class="img-area">
				<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 429 455.6">
					<defs>
						<style>.separator-25 {fill: none;}.separator-2 {clip-path: url(#clip-path-<?php echo esc_attr( $unique_id ) ;?>);}</style>
						<clipPath id="clip-path-<?php echo esc_attr( $unique_id );?>" transform="translate(26.59 59.1)">
							<path class="separator-25" d="M21.8,236.2s1.94,5.33,5.66,6.57c1.93.16,11.13-6.64,15.94-7.53,0,0,5.23,1.55.84,4.87-7.7,1.94-13.18,10-13.18,10s4,7.17,5.26,11.89,2.08,4.42,6.62,5.36,5.25,6.72,5.25,6.72-3.14,8.05-.11,8.67,3,.62,4.7,7.78,4.15,8.85,4.15,8.85,4.7,7.78,9.79,5.07,13.17-10,13.17-10l2.49,4.27s3,3.22,11.7.06c13.42-19.55,61.38-40.46,62.74-44.41s0-10.35,0-10.35l5.24,4.14c5.92,2.16,11.69-2.53,15.81-4a13,13,0,0,0,6.18-4.84,38.23,38.23,0,0,1,7.69-4.52c3.3-1.2,3,.62,5.09-.13s0,0,.95-3.8,2.48,1.69,11.83-3.44,49.88-18.16,53.59-19.51,10.31-3.75,12.23-6.17,0-5.18,0-5.18l1.23-.45a101.12,101.12,0,0,1,12.65-3.74,192.73,192.73,0,0,1,22.28-2.93c5.5-.27,22.27-5.51,22.27-5.51-4.14-6.26-3.17-2.3-3.17-2.3l-20.78-1.93,2.47-.9c2.48-.9,29-1.07,31.5-2s16.92-1,16.92-1,1-3.8-6.62-5.36c-6.88-.95-52.54,4.45-62.43,8.05s-10.88-2.94-10.88-2.94l6.05-1.34c6.05-1.34,38.22-7.87,46.89-8.44a27.57,27.57,0,0,0,14.43-5.25s-2.5-6.86-5.8-5.66-6.73.73-8-4,2.48-.9,4.54-1.66,12.5-5.41,14.83-8S352,137.6,352,137.6s-13.63-.22-16.79.06-2.89-1.53-3.86-2.91c.41-.15,47.31-6,47.31-6s1.37-1.36-4.14-3.67c-6.19-.33-91.06,6.39-95.46,7.13s0,0,2.19-4.25c15.68-3.12,79.22-10.71,81.82-12.52a20,20,0,0,1,3.85-2.26s-7-2.62-11-2-30,4.87-32.87,5.92-2.75.14-5.78-3.07c0,0,66-16.25,67.77-17.76s-.43-5-.43-5l-7.69,1.93c-7.7,1.94-14.72,1.91-16.78,2.66s-38.91,9.84-42.34,12-8.53-.35-8.53-.35,47.68-19.08,51-20.28A10.25,10.25,0,0,0,365,83.65S331.22,93.37,326.68,95s-2.75-2.45-2.75-2.45,2.05-3.33-12.93,3a40.94,40.94,0,0,1-27.92,1.54l2.47-.9c2.47-.91,11.56,1,24.48-4.6s65-17.62,65-17.62l2.74-5.31S379,63,365.13,69.81s-32.58,9.27-32.58,9.27,8.11-4.68,10.44-7.25S341.6,68,341.6,68,306.83,79,272.86,84.41s-29,8-31.16,9.61,0,0-1.66-2,24.51-9.9,36-14.1,34-5.37,36.91-6.42,28-7.61,44.4-12.7,15.66-8.29,15.66-8.29l-1.39-3.81-7.83,2.85c-5.36,2-9.76,2.69-9.77.1S386.51,38.73,388.57,38s4.52-4.24,3.7-3.94-26-.89-41,5.42-30.39,7.61-34.37,8.2-3.33-6.56-3.33-6.56,20.76-5.83,24.89-7.33,4.67,0,3-4.55,4.12-1.5,6.32-3.16,3-7.14-3.32-6.56-53.77,10.08-56.24,11-5-3.38-5-3.38l4.53-1.65c29.69-10.8,68.2-15.32,70.26-16.08S357.79,6,357,3.74s0,0-31.63,5.47-104,33.56-153.53,49-79.15,34-82.86,35.33,3.43-2.11-1.39-3.81C43.14,99.84,6.36,129.62,7.6,129.17s5.66,6.57,5.66,6.57S5.56,137.68,2.39,138,0,154.39.39,156.83s1.79,3.66,4.56,8.69.32,16.28,1.16,18.57,6.74,1.86,8.53.34,4.95.79,6.47,3.69c-5.09.12-11.81,6-11.81,6l3,8.39s7.69-4.53,11-5.73,1.93,2.75,1.93,2.75l-5.19,11.38s-3.43,4.7-6.73,5.9S21.8,236.2,21.8,236.2Zm282.07-84.54,3.3-1.21c3.3-1.2,12.39.68,12.39.68s1.81,4.07-.13,3.49c-5.23-1.54-15.82,1.45-15.82,1.45Zm-48.08-23.07s12.38-1.91,14-2.51-2.88,6.22-2.88,6.22-9.9,1-11.55,1.62S255.79,128.59,255.79,128.59Zm13.34,46.93s4.11-6.67,5.78-2.1c1.11,3.05-.68,4.56-.68,4.56l-4.12,1.5C268.87,179.93,269.13,175.52,269.13,175.52ZM245.67,54.6c3.3-1.2,42.5-5.11,59.54-12.17,3.45,5.64,1,6.54,1,6.54s-54.32,8.56-61.47,9.43C240.73,59,244.72,58.4,245.67,54.6ZM369.61,5.69S367.12-.43,365.88,0l-4.95,1.8c-1.65.6,2.25,6.21,2.25,6.21Zm16.7,60.73-3.3,1.2L382.75,72s10.59-3,15.82-1.44c1.94.57.13-3.5.13-3.5S389.61,65.22,386.31,66.42Zm-33,88.83s-.26,4.41,1,4l4.12-1.5s1.79-1.51.68-4.56C357.38,148.58,353.27,155.25,353.27,155.25Z"/>
						</clipPath>
					</defs>
					<title><?php absp_render_title( $settings['team_member_name'] ); ?></title>
					<g id="Layer_2" data-name="Layer 2">
						<g id="Layer_1-2" data-name="Layer 1">
							<g class="separator-2"><image width="1000" height="1062" transform="scale(0.43)" xlink:href="<?php echo esc_url( $settings['team_member_image']['url'] ); ?>"/></g>
						</g>
					</g>
				</svg>
			</div>

		</div>
		<div class="data">
			<div class="title">
				<h2><?php absp_render_title( $settings['team_member_first_name'] ); ?> <span><?php absp_render_title( $settings['team_member_last_name'] ); ?></span>
				</h2>
			</div>
			<div class="designation">
				<span <?php $this->print_render_attribute_string( 'team_member_designation' ); ?>><?php absp_render_title( $settings['team_member_designation'] ) ?></span>
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 219.13 29.19">
					<g>
						<g id="Contents">
							<path class="separator" d="M9.36,4.8C6,5.17,7.14,4.43,5.3,6.65S3.08,9.23,3.08,9.23.5,9.23.13,12.55s0,7.39,1.84,7c2.22,0,3-1.11,2.59,1.84l-.37,3s-.37,1.11,3.32,1.84a31.91,31.91,0,0,0,5.54.74s-5.54,1.85-2.58,2.22,93.78-4.8,105.22-5.17,15.51-.74,13.67-2.22-6.65-.73-1.85-1.47,8.12-.37,11.08-.74,34.33-1.85,43.93-2.22,10.71-2.58,12.19-3-1.48.37,5.17,0,17.72.74,18.83-1.48,0-2.95-2.59-2.58-22.52,1.11-28.43-.74-8.49,0-10.34-.37a21.26,21.26,0,0,1-5.17-1.48c-1.47-.73-1.1-1.1-3.69-.73s-.74-3-9.23-3-22.89-1.84-31-1.84S107.94,0,83.94,0,20.44.37,9.36,4.8Z"/>
							<text class="cls-2" transform="translate(14.26 19.36)"></text>
						</g>
					</g>
				</svg>
			</div>

			<div <?php $this->print_render_attribute_string( 'team_member_about' ); ?> class="about">
				<?php absp_render_content( $settings['team_member_about'] );?>
			</div>
			<?php if ( $settings['team_member_social_media'] ) : ?>
				<div class="social_icons">
					<ul>
						<?php foreach ( $settings['team_member_social_media'] as $social_media ) : ?>
							<li class="elementor-repeater-item-<?php echo esc_attr( $social_media['_id'] ); ?>">
								<a href="<?php echo esc_url( $social_media['team_member_social_icon_url'] ); ?>">
									<i class="<?php echo esc_attr( $social_media['team_member_social_icon']['value'] ); ?>" aria-hidden="true"></i>
								</a>
							</li>
						<?php endforeach; ?>
					</ul>
				</div>
			<?php endif; ?>
		</div>
	</div>
</div>

